# Описание языка выражений для фильтров

Данный язык является DSL (domain specific language). И предназначен для гибкого описания условий для определения типа клиента и т.п. других штук.
На текущий момент язык фильтров используется только для определения fake-клиентов.

Все фильтры хранятся в таблице client_filter, состоящей из 2х колонок:
1. Type -- тип (на данной момент только fake)
2. Текстовое описание выражения.

## Cинтаксис

В общем случае выражение состоит из операции сравнения и аргументов слева и справа от данной операции.
Общий синтаксис:

<аргумент1> <операция> <аргумент2>

где 
* <аргумент> может быть идентификатором, строкой, числом, или другим выражением.
* <операция> - какая либой операция: ==, !=, =<, >=, ~, ++ и т.п. Описание операций смотри ниже.

Может быть применена унарная операция ! <аргумент> -- отрицание. Полное описание см ниже.

## Типы

Доступны следующие типы:

* <идентификатор> -- любая строка не заключенная в кавычки, внутри которой нет пробелов. Например: ip, sys_ver, client_ver и т.п.
Идентификаторы используются для адресации информации из внешних данных. Т.о. выражение всегда вычисляет что-то на основании данных заключенных в идентификаторах, или другими словами - переменных.

* "строка" -- произвольная строка ограниченная кавычками.

* 1234 -- число

* true -- предъопределенный идентификатор обозначающий ИСТИНА.
* false -- предъопределенный идентификатор обозначающий ЛОЖЬ.

## Операции

* \<arg1> ++ \<arg2> -- сложение аргументов как строк. Результат будет строка состоящая из \<arg1>\<arg2>. Например:
"привет." ++ "пока" = "привет.пока"
1 ++ 2 = "12"

* Операции сравнения: >= (больше или равно), =< (меньше или равно), = (равно), != (не равно), > (больше), <  (меньше) -- используются для сравнения величин.
Например: 1 > 2 -> false; 1 = 1 -> true

* Логическое отрицание: ! (\<arg>) -- эквивалентно \<arg> != false  

* Логическое умножение: &. true & true -> true, false & true -> false. 

* Логическое сложение: |. ```true | false -> true```, ```false | false -> false```.

* Матчинг ~. В настоящий момент используется только для матчинга IP адресов с CIDR строкой.
 ip ~ "127.0.0.0/8" -> false
 
* Антиматчинг !~ . ip !~ "127.0.0.0/8" эквивалентно: !( ip ~ "127.0.0.0/8" ) -> true

## Скобки

Для задания приоритета операций поддерживаются скобки ().

```(1 = 2) = false -> true``` 

## Группировки операций cравнения

Для сокращения записи введены операции сравнения c использованием списов в качестве второго аргумента:
Данная форма записи поддерживается для: =, !=, ~, !~

Пример:

* ```1 =&[ 1,2 ] -> false``` 

    это выражение эквивалентно:

    ```( 1 = 1 ) & ( 1 = 2 )```

* ```1 !=&[ 1,2 ] -> false``` 

    это выражение эквивалентно:

    ```( 1 != 1 ) & ( 1 != 2 )```



* ```1 =|[ 1,2 ] -> true``` 

    это выражение эквивалентно:

    ```( 1 = 1 ) | ( 1 = 2 )```

* ```1 !=|[ 1,2 ] -> true``` 

    это выражение эквивалентно:

    ```( 1 != 1 ) | ( 1 != 2 )```
    
## Матчинг внутри строк.

Внутри строк всегда действует специальный символ ```*``` обозначающий любое количество символов (или их полное отсутствие).    
Т.о.

* "hello" = "*llo" -> true
* "hello" = "*ll*" -> true
* "hello" = "hell*" -> true
* "hello" = "he*l*" -> true

и т.п.

## Доступные идентификаторы

В настоящий момент поддерживается следующие идентификаторы полей клиента, которые могут быть вставлены в код выражения:

* ```true``` - всегда ИСТИНА
* ```false``` - всегда ЛОЖЬ
* ```ip``` - специальный тип IP, можно матчить с помощью ~
* ```id``` - id-клиента как текст
* ```client_ver``` - версия клиента 
* ```name``` - имя клиента (строка)
* ```group``` - группа клиента (строка)
* ```ip``` - ip клиента, который был передан по команде /0/
* ```country``` - страна клиента (строка)
* ```sys_ver``` - версия системы (строка)
* ```importance``` - число
* ```userdefined``` - число

# Примеры:

Пусть значения идентификаторов представлены в виде словаря:
```
  #{
    <<"x">> => 1,
    <<"y">> => <<"hello">>,
    <<"ip">> => { ip, <<"162.76.2.1">> },
    <<"true">> => true
  }
```

тогда:

* 1 > 2 -> false
* x =< 2 -> true
* 1 ++ 2 = 12 -> true
* x ++ 2 = 12 -> true
* x ++ 2 = 2 ++ x -> false
* x ++ 1 = 1 ++ x -> true
* y = "*lo" -> true
* y = "*lo*" -> true
* y = "lo*" -> false
* !(x>1)&y=\"hello\" -> true
* y =& [ "*lo", "hel*"] -> true
* y =|[ \"lo*\", \"(hel*\"] -> false
* ip ~ \"162.76.0.0/16\" -> true
* ip !~ \"161.76.0.0/16\" -> true

